#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>

#include "a.h"

#include "ParserIO.h"
#include "Parser.h"


Parser::Parser(char *program,int source)
:m_pclParserIO(NULL)
,m_tab_pos(0)
,m_obufptr(0)
{
	LINE *ln;

	strcpy(m_run_program, program);
	if (source)
	{
		m_linebase = NULL;
		m_variablebase = NULL;
		m_nextbase = NULL;
		m_subbase = NULL;
		m_openbase = NULL;
		m_database = NULL;
		m_funcbase = NULL;

		m_running = 0;
		this -> read_file(m_run_program);
		for (ln = m_linebase; ln; ln = ln -> next)
		{
			m_current_line = ln;
			// generate source listing
			if (ln -> line > -1)
				printf(" %5d",ln -> line);
			else
				printf("      ");
			printf(" %s\n",ln -> the_str);

			strcpy(m_the_str,ln -> the_str);
			m_the_ptr = 0;
			if (yyparse( this ))
			{
				break;
			}
		}
		this -> finish();
	}
}


Parser::~Parser()
{
}


void Parser::run()
{
	do
	{
		// reset lists
		m_linebase = NULL;
		m_variablebase = NULL;
		m_nextbase = NULL;
		m_subbase = NULL;
		m_openbase = NULL;
		m_database = NULL;
		m_funcbase = NULL;

		// on error ptr, open file ptr
		m_onerror = NULL;
		m_fil = NULL;

		// running flag OFF
		m_running = 0;

		// read file (parse DATA)
		this -> read_file(m_run_program);
		this -> load_variables();

		m_current_data = m_database;
		m_dataptr = 0;

		*m_run_program = 0;

		// running flag ON
		m_running = 1;

		// execute program
		this -> execute();
		this -> flush_obuf();
		this -> save_variables();

		// clear lists
		this -> finish();

	} while (*m_run_program);
}


void Parser::addlist(void *_base,void *_item)
{
	LINE **base = (LINE **)_base;
	LINE *item = (LINE *)_item;
	LINE *q;

	item -> next = NULL;
	q = *base;
	if (!q)
		*base = item;
	else
	{
		while (q -> next)
			q = q -> next;
		q -> next = item;
	}
}

void Parser::removelist(void *_base,void *_item)
{
	LINE **base = (LINE **)_base;
	LINE *item = (LINE *)_item;
	LINE *q,*prev = NULL;

	if (item == *base)
		*base = item -> next;
	else
	{
		for (q = *base; q; q = q -> next)
			if (item == q)
			{
				prev -> next = item -> next;
				break;
			}
			else
				prev = q;
	}
}

void Parser::read_file(char *filename)
{
	FILE *fil;
	LINE *ln;
	int parent;
	int child;
	int i;
	short size;
	short q;	// quote
	short ifc;
	short data;
	short rem;
	unsigned char c_length;
	unsigned char c_eight;
	unsigned char c_line1;
	unsigned char c_line2;
	unsigned char c;
	char slask[1024];

	strcpy(m_programname,filename);
	getcwd(m_program_cwd,200);
fprintf(stderr,"*** Current program: '%s' ***\n",m_programname);
fprintf(stderr,"getcwd() == '%s'\n",m_program_cwd);

	fil = fopen(filename,"rb");
	if (fil)
	{
		fread(&c,1,1,fil);		// line number
		while (!feof(fil))
		{
			while ((c == 13 || c == 10) && !feof(fil))
				fread(&c,1,1,fil);
			i = 0;
			while (isdigit(c) && !feof(fil))
			{
				slask[i++] = c;
				fread(&c,1,1,fil);
			}
			slask[i] = 0;
//printf("line: '%s'\n",slask);
			ln = (LINE *)malloc(sizeof(LINE));
			ln -> line = *slask ? atoi(slask) : -1;
			ln -> parent = ln -> line;
			ln -> child = 0;
			parent = ln -> line;
			child = 1;
			// line data
			if (*slask) // only read next char if line number
				fread(&c,1,1,fil);
			*slask = 0;
			q = 0;
			ifc = 0;
			data = 0;
			rem = 0;
			while (c != 0x0a && !feof(fil))
			{
				while (!*slask && (c == ' ' || c == 9) && !feof(fil))
					fread(&c,1,1,fil);
				if (strlen(slask) > 2 && !strcasecmp(slask + strlen(slask) - 3,"if "))
					ifc = 1;
				if (!strcasecmp(slask,"rem"))
					rem = 1;
				if (!strcasecmp(slask,"data"))
					data = 1;
				if (ifc && !q && strlen(slask) > 4 && !strcasecmp(slask + strlen(slask) - 4,"then"))
				{
					slask[strlen(slask) - 4] = 0;
					ln -> the_str = (char *)malloc(strlen(slask) + 1);
					strcpy(ln -> the_str,slask);
					if (*slask)
						addlist(&m_linebase,ln);
					else
						free(ln);
					if (data && *slask)
					{
						strcpy(m_the_str,slask);
						m_the_ptr = 0;
						m_current_line = ln;
						if (yyparse(this))
							m_next_line = NULL;
					}

					ln = (LINE *)malloc(sizeof(LINE));
					ln -> line = -1;
					ln -> parent = parent;
					ln -> child = child++;
					strcpy(slask,"THEN");
					q = 0;
					ifc = 0;
					data = 0;
					rem = 0;
				}

/*
				if (!strcasecmp(slask,"else"))
				{
					ln -> the_str = (char *)malloc(strlen(slask) + 1);
					strcpy(ln -> the_str,slask);
					if (*slask)
						addlist(&m_linebase,ln);
					else
						free(ln);
					if (data && *slask)
					{
						strcpy(m_the_str,slask);
						m_the_ptr = 0;
						m_current_line = ln;
						if (yyparse(this))
							m_next_line = NULL;
					}

					ln = (LINE *)malloc(sizeof(LINE));
					ln -> line = -1;
					ln -> parent = parent;
					ln -> child = child++;
					*slask = 0;
					q = 0;
					ifc = 0;
					data = 0;
					rem = 0;
				}
				else
*/
				if (c == '\'' && !*slask)
				{
					strcpy(slask,"REM ");
					rem = 1;
				}
				else
/*
				if (c == '?' && !*slask)
				{
					strcpy(slask,"PRINT ");
				}
				else
*/
				if (c == ':' && !q && !rem)
				{
					while (slask[strlen(slask) - 1] == 13 || slask[strlen(slask) - 1] == 10)
						slask[strlen(slask) - 1] = 0;
//printf("text: '%s'\n",slask);
					ln -> the_str = (char *)malloc(strlen(slask) + 1);
					strcpy(ln -> the_str,slask);
					if (*slask)
						addlist(&m_linebase,ln);
					else
						free(ln);
					if (data && *slask)
					{
						strcpy(m_the_str,slask);
						m_the_ptr = 0;
						m_current_line = ln;
						if (yyparse(this))
							m_next_line = NULL;
					}

					ln = (LINE *)malloc(sizeof(LINE));
					ln -> line = -1;
					ln -> parent = parent;
					ln -> child = child++;
					*slask = 0;
					q = 0;
					ifc = 0;
					data = 0;
					rem = 0;
				}
				else
				{
					if (!q && c >= 'a' && c <= 'z')
						c -= 32;
					sprintf(slask + strlen(slask),"%c",c);
					if (c == 34)
						q = !q;
				}
				fread(&c,1,1,fil);
			}
			while (slask[strlen(slask) - 1] == 13 || slask[strlen(slask) - 1] == 10)
				slask[strlen(slask) - 1] = 0;
//printf("text: '%s'\n",slask);
			ln -> the_str = (char *)malloc(strlen(slask) + 1);
			strcpy(ln -> the_str,slask);
			if (*slask)
				addlist(&m_linebase,ln);
			else
				free(ln);
			if (data && *slask)
			{
				strcpy(m_the_str,slask);
				m_the_ptr = 0;
				m_current_line = ln;
				if (yyparse(this))
					m_next_line = NULL;
			}
			fread(&c,1,1,fil);	// first char next line
		}
		fclose(fil);
	}
	else
	{
		fprintf(stderr,"Couldn't open '%s'...\n",filename);
//		exit(-1);
	}
}

void Parser::execute()
{
	m_current_line = m_linebase;
	while (m_current_line)
	{
		m_next_line = m_current_line -> next;
		strcpy(m_the_str,m_current_line -> the_str);
		m_the_ptr = 0;
#ifdef DEBUGEXPR
fprintf(stderr," %4d %s\n",m_current_line -> line,m_current_line -> the_str);
#endif
		m_placeholder = NULL;
		if (yyparse(this))
			m_next_line = NULL;
		if (m_placeholder)
			m_placeholder -> value = m_placeholder -> fnvalue;
		m_current_line = m_next_line;
	}
}

void Parser::finish()
{
	LINE *ln;
	LINE *tmpln;
	VARIABLE *v;
	VARIABLE *tmpv;
	NEXT *nx;
	NEXT *tmpnx;
	SUB *sub;
	SUB *tmpsub;
	OPEN *o;
	OPEN *tmpo;
	DATA *d;
	DATA *tmpd;
	FUNC *f;
	FUNC *tmpf;

	for (ln = m_linebase; ln; ln = tmpln)
	{
		tmpln = ln -> next;
		free(ln -> the_str);
		free(ln);
	}
	for (v = m_variablebase; v; v = tmpv)
	{
		tmpv = v -> next;
		free(v);
	}
	for (nx = m_nextbase; nx; nx = tmpnx)
	{
		tmpnx = nx -> next;
		free(nx);
	}
	for (sub = m_subbase; sub; sub = tmpsub)
	{
		tmpsub = sub -> next;
		free(sub);
	}
	for (o = m_openbase; o; o = tmpo)
	{
		tmpo = o -> next;
		fclose(o -> fil);
		free(o);
	}
	for (d = m_database; d; d = tmpd)
	{
		tmpd = d -> next;
		free(d -> data);
		free(d);
	}
	for (f = m_funcbase; f; f = tmpf)
	{
		tmpf = f -> next;
		free(f);
	}
}


VARIABLE *Parser::reg_variable(char *name,EXPRLIST *p)
{
	VARIABLE *v;
	int i;
	char type[2];
/*
	if (*name != '$') // not a function (def fn)
	{
		switch (name[strlen(name) - 1])
		{
		case '$':
			strcpy(type,"$");
			name[strlen(name) - 1] = 0;
			break;
		case '%':
			strcpy(type,"%");
			name[strlen(name) - 1] = 0;
			break;
		default:
			*type = 0;
		}
		name[2] = 0;
		strcat(name,type);
	}
*/
	if (p)
	{
		strcat(name,"(");
		for (i = 0; i < p -> qty; i++)
		{
			if (i)
				strcat(name,",");
			sprintf(name + strlen(name),"%d",(int)(p -> values[i] + 0.01));
		}
		strcat(name,")");
	}

	for (v = m_variablebase; v; v = v -> next)
	{
		if (!strcmp(v -> name,name))
			break;
	}
	if (!v)
	{
		v = (VARIABLE *)malloc(sizeof(VARIABLE));
		if (!v)
		{
			fprintf(stderr,"malloc failed\n");
			exit(-1);
		}
		strcpy(v -> name,name);
		v -> ivalue = 0;
		v -> value = v -> fnvalue = 0;
		*v -> svalue = 0;
		v -> next = m_variablebase;
		m_variablebase = v;
	}
	return v;
}


void Parser::verify_filename(char *s)
{
	int i;

	if (s)
	{
		for (i = 0; i < (int)strlen(s); i++)
		{
			switch (s[i])
			{
			case '/':
				s[i] = '_';
			}
		}
	}
}


void Parser::text_output(char *s)
{
	OPEN *o;
	char *cmd;
	char *arg;
	char *option;
	long offset;
	int i;
	short cmnum;
	short option_s;
	short option_d;
	short option_l;
	short option_r;
	char slask[1024];

	if (*s == 4)	// CHR$(4) - dos command
	{
		if (s[strlen(s) - 1] == '\n');
			s[strlen(s) - 1] = 0;
		m_file_read = 0;
		m_file_write = 0;
		m_fil = NULL;
		cmd = strtok(s + 1," ");
		if (!cmd)
		{
#ifdef DEBUG
			fprintf(stderr," * Empty CHR$(4)\n");
#endif
			return;
		}
		arg = strtok(NULL,",");
#ifdef DEBUG
fprintf(stderr," * file command '%s' argument '%s'\n",cmd,arg);
#endif
		if (!strcmp(cmd,"RUN"))
			cmnum = 1;
		else
		if (!strcmp(cmd,"OPEN"))
			cmnum = 2;
		else
		if (!strcmp(cmd,"CLOSE"))
			cmnum = 3;
		else
		if (!strcmp(cmd,"READ"))
			cmnum = 4;
		else
		if (!strcmp(cmd,"WRITE"))
			cmnum = 5;
		else
		if (!strcmp(cmd,"DELETE"))
			cmnum = 6;
		else
		{
			fprintf(stderr,"##############################################\n");
			fprintf(stderr,"#### implement dos command\n");
			fprintf(stderr,"####  cmd '%s' arg '%s'\n",cmd,arg);
			cmnum = 0;
		}

		option = strtok(NULL,",");
		option_s = -1;
		option_d = -1;
		option_l = -1;
		option_r = -1;
		while (option)
		{
#ifdef DEBUG
fprintf(stderr,"   option '%s'\n",option);
#endif
			if (!cmnum)
			{
				fprintf(stderr,"####  cmd '%s' arg '%s' option '%s'\n",cmd,arg,option);
			}
			else
			switch (*option)
			{
			case 'S':
				option_s = atoi(option + 1);
				break;
			case 'D':
				option_d = atoi(option + 1);
				break;
			case 'L':
				option_l = atoi(option + 1);
				break;
			case 'R':
				option_r = atoi(option + 1);
				break;
			default:
				fprintf(stderr,"####  cmd '%s' arg '%s' option '%s'\n",cmd,arg,option);
				fprintf(stderr,"##############################################\n");
			}
			option = strtok(NULL,",");
		} // while (option)

		if (!cmnum)
		{
			fprintf(stderr,"##############################################\n");
		}

		if (!m_running)
			return;

		switch (cmnum)
		{
		case 1: // run
			verify_filename( arg );
			fprintf(stderr," * RUN '%s'\n",arg);
			strcpy(m_run_program,arg);
			m_next_line = NULL;
			break;
		case 2: // open ,S ,D ,L
			verify_filename( arg );
			for (o = m_openbase; o; o = o -> next)
				if (!strcmp(o -> name,arg))
					break;
			if (o)
			{
//				fprintf(stderr," *** FILE already OPEN\n");
			}
			else
			{
				o = (OPEN *)malloc(sizeof(OPEN));
				o -> fil = fopen(arg,"r+b");
				if (!o -> fil)
					o -> fil = fopen(arg,"w+b");
				if (!o -> fil)
				{
					fprintf(stderr," *** OPEN '%s' failed\n",arg);
					m_next_line = m_onerror;
					free(o);
				}
				else
				{
					strcpy(o -> name,arg);
					stat(arg,&o -> file_stat);
					o -> option_s = option_s;
					o -> option_d = option_d;
					o -> option_l = option_l;
					o -> option_r = 0;
					addlist(&m_openbase,o);
				}
			}
			break;
		case 3: // close
			if (arg)
			{
				verify_filename( arg );
				for (o = m_openbase; o; o = o -> next)
					if (!strcmp(o -> name,arg))
						break;
				if (!o)
					fprintf(stderr," *** FILE not OPEN (CLOSE)\n");
				else
				{
					fclose(o -> fil);
					removelist(&m_openbase,o);
					free(o);
				}
			}
			else
			{
				while (m_openbase)
				{
					o = m_openbase;
					fclose(o -> fil);
					removelist(&m_openbase,o);
					free(o);
				}
			}
			break;
		case 4: // read ,R
			verify_filename( arg );
			for (o = m_openbase; o; o = o -> next)
				if (!strcmp(o -> name,arg))
					break;
			if (!o)
				fprintf(stderr," *** FILE not OPEN (READ)\n");
			else
			{
				if (option_r > -1)
				{
					o -> option_r = option_r;
					offset = (long)o -> option_l * (long)o -> option_r;
					if (offset > o -> file_stat.st_size)
						m_next_line = m_onerror;
//					fprintf(stderr," * READ '%s' ,L%d ,R%d  Offset 0x%04lx\n",arg,o -> option_l,o -> option_r,offset);
					if (fseek(o -> fil,offset,SEEK_SET))
						m_next_line = m_onerror;
				}
				m_file_read = 1;
				m_fil = o -> fil;
			}
			break;
		case 5: // write ,R
			verify_filename( arg );
			for (o = m_openbase; o; o = o -> next)
				if (!strcmp(o -> name,arg))
					break;
			if (!o)
				fprintf(stderr," *** FILE not OPEN (WRITE)\n");
			else
			{
#ifdef DEBUG
fprintf(stderr," * Write to file '%s'\n",o -> name);
#endif
				if (option_r > -1)
				{
					o -> option_r = option_r;
					offset = (long)o -> option_l * (long)o -> option_r;
#ifdef DEBUG
					fprintf(stderr," * WRITE '%s' ,L%d ,R%d  Offset 0x%04lx\n",arg,o -> option_l,o -> option_r,offset);
#endif
					if (fseek(o -> fil,offset,SEEK_SET))
						m_next_line = m_onerror;
				}
				m_file_write = 1;
				m_fil = o -> fil;
#ifdef DEBUG
fprintf(stderr," * ...\n");
#endif
			}
			break;
		case 6: // delete
			verify_filename( arg );
			unlink(arg);
			break;

		default:
			break;
		} // switch (cmnum)

	}
	else
	{
		if (!m_running)
			return;

		if (m_fil && m_file_write)
		{
			if (s[strlen(s) - 1] == 0x0a)
				s[strlen(s) - 1] = 0x8d;
			fwrite(s,strlen(s),1,m_fil);
		}
		else
		if (m_pclParserIO)	// callbacks class
		{
			int l = strlen(s);

			if (m_obufptr + l >= OBUFSIZE - 1)
			{
				flush_obuf();
			}
			memmove(m_obuf + m_obufptr, s, l);
			m_obufptr += l;
		}
		else	// stdout
		{
			printf("#### USE PARSER IO FUNCTION ####\n");
			exit(-1);

			i = 0;
			while (s[i])
			{
				if (strlen(s + i) > 40)
				{
					strncpy(slask,s + i,40);
					slask[40] = 0;
					printf("%s\n",slask);
					i += 40;
				}
				else
				{
					printf("%s",s + i);
					i += strlen(s + i);
				}
				fflush(stdout);
			}
		}
	}
}

void Parser::file_input(char *s,int l)
{
	int i = 0;
	short q = 0;
	unsigned char c;

	if (m_fil)
		fread(&c,1,1,m_fil);
	while (m_fil && !feof(m_fil) && c != 0x8d && (q || (c & 0x7f) != ',') && c)
	{
		if (i >= l - 1)
		{
			fprintf(stderr," ********* BUFFER OVERFLOW ********\n");
			s[l - 1] = 0;
			fprintf(stderr,"%s\n",s);
			exit(-1);
		}
		s[i++] = c & 0x7f;
		if ( (c & 0x7f) == 34)
			q = !q;
#ifdef DEBUG
fprintf(stderr,"%c",c & 0x7f);
#endif
		fread(&c,1,1,m_fil);
	}
	s[i] = 0;
	if (*s == 34 && s[strlen(s) - 1] == 34)
	{
		memmove(s,s + 1,strlen(s) + 1);
		s[strlen(s) - 1] = 0;
	}
#ifdef DEBUG
fprintf(stderr,"\n");
#endif
}


#define DC (m_current_data?m_current_data->data[m_dataptr]:0)

void Parser::get_data(char *s)
{
	int x = 0;

	while (DC == ' ' || DC == 9)
		m_dataptr++;
	if (!DC)
	{
		m_current_data = m_current_data ? m_current_data -> next : NULL;
		m_dataptr = 0;
		while (DC == ' ' || DC == 9)
			m_dataptr++;
	}
	if (DC)
	{
		while (DC && DC != ',')
		{
			s[x++] = DC;
			m_dataptr++;
		}
		if (DC == ',')
			m_dataptr++;
	}
	s[x] = 0;
}

void Parser::read_data(VARLIST *vl)
{
	int i;

	for (i = 0; i < vl -> qty; i++)
	{
		get_data(vl -> var[i] -> svalue);
		vl -> var[i] -> value = atof(vl -> var[i] -> svalue);
#ifdef DEBUGDATA
fprintf(stderr,"Read Data;  %s = '%s'\n",vl -> var[i] -> name,vl -> var[i] -> svalue);
#endif
	}
}

void Parser::SetParserIO(ParserIO *pclIO)
{
	m_pclParserIO = pclIO;
}

void Parser::flush_obuf(void)
{
	if (m_pclParserIO)
	{
		m_pclParserIO -> write_text(m_obuf, m_obufptr);
		m_obufptr = 0;
	}
}

void Parser::inputstring(char *s,int l)
{
	int ll = l;
	int i;

	if (m_pclParserIO)
	{
		flush_obuf();
		m_pclParserIO -> read_text(s,&ll);
		s[ll] = 0;
		while (strlen(s) && (s[strlen(s) - 1] == 13 || s[strlen(s) - 1] == 10))
			s[strlen(s) - 1] = 0;
	}
	else
	{
		printf("#### USE PARSER IO FUNCTION ####\n");
		exit(-1);
//		gets(s);
		ll = read(0, s, l);
		s[ll] = 0;
		while (strlen(s) && (s[strlen(s) - 1] == 13 || s[strlen(s) - 1] == 10))
		{
			s[strlen(s) - 1] = 0;
		}
		if (*s == '.')
		{
			if (chdir( s ) == -1)
			{
				perror("chdir() failed");
				fprintf(stderr," ('%s') length %d\n",s,strlen(s));
			}
		}
		for (i = 0; i < ll; i++)
			if (s[i] >= 'a' && s[i] <= 'z')
				s[i] -= 32;
	}
}

void Parser::save_variables()
{
	FILE *fil;
	VARIABLE *v;
	char slask[200];

	sprintf(slask,"%s/%s.lastrun",m_program_cwd,m_programname);
	if ((fil = fopen(slask,"wb")) != NULL)
	{
		for (v = m_variablebase; v; v = v -> next)
		{
			fwrite(v,1,sizeof(VARIABLE),fil);
		}
		fclose(fil);
	}
}

void Parser::load_variables()
{
	FILE *fil;
	VARIABLE *v;
	char slask[200];

	sprintf(slask,"%s.lastrun",m_programname);
	if ((fil = fopen(slask,"rb")) != NULL)
	{
		v = new VARIABLE;
		fread(v,1,sizeof(VARIABLE),fil);
		while (!feof(fil))
		{
			addlist(&m_variablebase,v);

			v = new VARIABLE;
			fread(v,1,sizeof(VARIABLE),fil);
		}
		delete v;
		fclose(fil);
	}
}

VARIABLE *Parser::get_variable(char *name)
{
	VARIABLE *v;
	
	for (v = m_variablebase; v; v = v -> next)
		if (!strcmp(v -> name,name))
			break;
	return v;
}

int Parser::peek(int addr)
{
	switch (addr)
	{
	default:
		return m_mem[addr];
	}
}

void Parser::poke(int a,int value)
{
	int addr = a;

	if (addr < 0)
		addr += 65536;
	m_mem[addr] = value;
#ifdef DEBUGMEM
fprintf(stderr,"poke(%d,%d)\n",addr,value);
#endif
}
